<?php

include '../lib/locale/en_EN/messages.php';


//vars
if(isset($_SERVER['HTTP_HOST'])){
    $protocol = ( (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') || $_SERVER['SERVER_PORT'] == 443) ? 'https://' : 'http://' ;
    $site_url_full =  $protocol.$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];
    $uri_parts = explode('?',$site_url_full);
    $site_url = (isset($uri_parts[0])) ? $uri_parts[0] : $site_url_full;
} else {
    $site_url = 'http://localhost';
}
?>

<!DOCTYPE html>
<html lang="<?php echo $lang; ?>">
<head>
    <meta charset="UTF-8">
    <title>LyraPG PAYMENT PHP</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.6/css/bootstrap.min.css" />
    <script   src="https://code.jquery.com/jquery-2.2.4.min.js"   integrity="sha256-BbhdlvQf/xTY9gja0Dq3HiwQF8LaCRTXxZKRutelT44="   crossorigin="anonymous"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.6/js/bootstrap.min.js"></script>
    <!-- Custom CSS -->
    <style>
        body {
            padding-top: 70px;
            /* Required padding for .navbar-fixed-top. Remove if using .navbar-static-top. Change if height of navigation changes. */
            padding-bottom: 8em;
        }
        .form-control{min-width: 220px;}
    </style>
</head>
<body>



<?php if(isset($_POST)): ?>
<!-- Page Content -->
<div class="container">
    <div class="row">
        <div class="col-lg-12" style="max-width: 92%;">
            <br><br>
            <h2><?php echo $i18n['datasent']; ?></h2>
            <p><?php echo $i18n['note']; ?> <br>
                <?php echo $i18n['debugdesc']; ?></p>
<?php
/**
 * Toolbox initialisation, using LyraPG account informations
 * Required : ShopID + CERTIFICATE + platform URL
 */
$toolbox = require "../config/config.php";


/**
 * Retrieve FORM DATA
 */
$formData = $toolbox->getFormData($_POST);

/**
 * Output the form in html
 */
$form = '<form action="'.$formData['form']['action'].'" method="'.$formData['form']['method'].'" accept-charset="'.$formData['form']['accept-charset'].'" id="auto-submit-form">';
$form .= '<table class="table table-bordered">';
foreach ($formData['fields'] as $name => $value) {

    $doc_name = (strpos($name, 'vads_') !== false) ? str_replace('_','-',$name): false;
    $form .= '<tr>';
    $form .= '<td><label for="'. $name. '">'.$name.'</a></label></td>';
    $form .= '<td><input type="text" readonly="readonly"  name="'.$name.'" value="'.$value.'" /></td>';
    $form .= '</tr>';
}
$form .= '</table>';
$form .= '<input type="submit" name="pay-submit" value="'.'Pay'.'" class="btn btn-primary btn-lg btn-block"/>';
$form .= '</form>';

echo $form;
?>
<?php if($toolbox->debug == false){ ?>
    <script type="text/javascript">
        document.getElementById('auto-submit-form').submit(); // SUBMIT FORM
    </script>
<?php } ?>

        </div></div></div>
<?php else: ?>
    <?php echo $i18n['nopostdata']; ?>
<?php endif; ?>
</body>
</html>
